package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.OrientationDegreesDouble
import scala.jdk.CollectionConverters._
final case class Orientation(
    degrees: Optional[OrientationDegreesDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.Orientation = {
    import Orientation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.Orientation
      .builder()
      .optionallyWith(
        degrees.map(value =>
          OrientationDegreesDouble.unwrap(value): java.lang.Double
        )
      )(_.degrees)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.Orientation.ReadOnly =
    zio.aws.iotroborunner.model.Orientation.wrap(buildAwsValue())
}
object Orientation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.Orientation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.Orientation =
      zio.aws.iotroborunner.model.Orientation(degrees.map(value => value))
    def degrees: Optional[OrientationDegreesDouble]
    def getDegrees: ZIO[Any, AwsError, OrientationDegreesDouble] =
      AwsError.unwrapOptionField("degrees", degrees)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.Orientation
  ) extends zio.aws.iotroborunner.model.Orientation.ReadOnly {
    override val degrees: Optional[OrientationDegreesDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.degrees())
        .map(value =>
          zio.aws.iotroborunner.model.primitives.OrientationDegreesDouble(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.Orientation
  ): zio.aws.iotroborunner.model.Orientation.ReadOnly = new Wrapper(impl)
}
