package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListDestinationsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    destinations: Optional[Iterable[zio.aws.iotroborunner.model.Destination]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse = {
    import ListDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.ListDestinationsResponse.ReadOnly =
    zio.aws.iotroborunner.model.ListDestinationsResponse.wrap(buildAwsValue())
}
object ListDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.ListDestinationsResponse =
      zio.aws.iotroborunner.model.ListDestinationsResponse(
        nextToken.map(value => value),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def destinations
        : Optional[List[zio.aws.iotroborunner.model.Destination.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.iotroborunner.model.Destination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse
  ) extends zio.aws.iotroborunner.model.ListDestinationsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.PaginationToken(value)
      )
    override val destinations
        : Optional[List[zio.aws.iotroborunner.model.Destination.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotroborunner.model.Destination.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse
  ): zio.aws.iotroborunner.model.ListDestinationsResponse.ReadOnly =
    new Wrapper(impl)
}
