package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.WorkerGenericIdentifier
import scala.jdk.CollectionConverters._
final case class DeleteWorkerRequest(id: WorkerGenericIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerRequest = {
    import DeleteWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerRequest
      .builder()
      .id(WorkerGenericIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.DeleteWorkerRequest.ReadOnly =
    zio.aws.iotroborunner.model.DeleteWorkerRequest.wrap(buildAwsValue())
}
object DeleteWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.DeleteWorkerRequest =
      zio.aws.iotroborunner.model.DeleteWorkerRequest(id)
    def id: WorkerGenericIdentifier
    def getId: ZIO[Any, Nothing, WorkerGenericIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerRequest
  ) extends zio.aws.iotroborunner.model.DeleteWorkerRequest.ReadOnly {
    override val id: WorkerGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.WorkerGenericIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerRequest
  ): zio.aws.iotroborunner.model.DeleteWorkerRequest.ReadOnly = new Wrapper(
    impl
  )
}
