package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.{
  UpdatedAtTimestamp,
  CreatedAtTimestamp,
  WorkerFleetId,
  WorkerFleetArn
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateWorkerFleetResponse(
    arn: WorkerFleetArn,
    id: WorkerFleetId,
    createdAt: CreatedAtTimestamp,
    updatedAt: UpdatedAtTimestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetResponse = {
    import CreateWorkerFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetResponse
      .builder()
      .arn(WorkerFleetArn.unwrap(arn): java.lang.String)
      .id(WorkerFleetId.unwrap(id): java.lang.String)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.CreateWorkerFleetResponse.ReadOnly =
    zio.aws.iotroborunner.model.CreateWorkerFleetResponse.wrap(buildAwsValue())
}
object CreateWorkerFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CreateWorkerFleetResponse =
      zio.aws.iotroborunner.model.CreateWorkerFleetResponse(
        arn,
        id,
        createdAt,
        updatedAt
      )
    def arn: WorkerFleetArn
    def id: WorkerFleetId
    def createdAt: CreatedAtTimestamp
    def updatedAt: UpdatedAtTimestamp
    def getArn: ZIO[Any, Nothing, WorkerFleetArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, WorkerFleetId] = ZIO.succeed(id)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetResponse
  ) extends zio.aws.iotroborunner.model.CreateWorkerFleetResponse.ReadOnly {
    override val arn: WorkerFleetArn =
      zio.aws.iotroborunner.model.primitives.WorkerFleetArn(impl.arn())
    override val id: WorkerFleetId =
      zio.aws.iotroborunner.model.primitives.WorkerFleetId(impl.id())
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetResponse
  ): zio.aws.iotroborunner.model.CreateWorkerFleetResponse.ReadOnly =
    new Wrapper(impl)
}
