package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.WorkerFleetGenericIdentifier
import scala.jdk.CollectionConverters._
final case class DeleteWorkerFleetRequest(id: WorkerFleetGenericIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerFleetRequest = {
    import DeleteWorkerFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerFleetRequest
      .builder()
      .id(WorkerFleetGenericIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.DeleteWorkerFleetRequest.ReadOnly =
    zio.aws.iotroborunner.model.DeleteWorkerFleetRequest.wrap(buildAwsValue())
}
object DeleteWorkerFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.DeleteWorkerFleetRequest =
      zio.aws.iotroborunner.model.DeleteWorkerFleetRequest(id)
    def id: WorkerFleetGenericIdentifier
    def getId: ZIO[Any, Nothing, WorkerFleetGenericIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerFleetRequest
  ) extends zio.aws.iotroborunner.model.DeleteWorkerFleetRequest.ReadOnly {
    override val id: WorkerFleetGenericIdentifier =
      zio.aws.iotroborunner.model.primitives
        .WorkerFleetGenericIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerFleetRequest
  ): zio.aws.iotroborunner.model.DeleteWorkerFleetRequest.ReadOnly =
    new Wrapper(impl)
}
