package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListSitesResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sites: Optional[Iterable[zio.aws.iotroborunner.model.Site]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse = {
    import ListSitesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        sites.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sites)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.ListSitesResponse.ReadOnly =
    zio.aws.iotroborunner.model.ListSitesResponse.wrap(buildAwsValue())
}
object ListSitesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.ListSitesResponse =
      zio.aws.iotroborunner.model.ListSitesResponse(
        nextToken.map(value => value),
        sites.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def sites: Optional[List[zio.aws.iotroborunner.model.Site.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSites
        : ZIO[Any, AwsError, List[zio.aws.iotroborunner.model.Site.ReadOnly]] =
      AwsError.unwrapOptionField("sites", sites)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse
  ) extends zio.aws.iotroborunner.model.ListSitesResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.PaginationToken(value)
      )
    override val sites
        : Optional[List[zio.aws.iotroborunner.model.Site.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sites())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotroborunner.model.Site.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse
  ): zio.aws.iotroborunner.model.ListSitesResponse.ReadOnly = new Wrapper(impl)
}
