package zio.aws.iotroborunner.model
import java.time.Instant
import zio.aws.iotroborunner.model.primitives.{
  DestinationId,
  DestinationAdditionalFixedProperties,
  SiteArn,
  UpdatedAtTimestamp,
  DestinationArn,
  CreatedAtTimestamp,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetDestinationResponse(
    arn: DestinationArn,
    id: DestinationId,
    name: Name,
    site: SiteArn,
    createdAt: CreatedAtTimestamp,
    updatedAt: UpdatedAtTimestamp,
    state: zio.aws.iotroborunner.model.DestinationState,
    additionalFixedProperties: Optional[DestinationAdditionalFixedProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.GetDestinationResponse = {
    import GetDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.GetDestinationResponse
      .builder()
      .arn(DestinationArn.unwrap(arn): java.lang.String)
      .id(DestinationId.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .site(SiteArn.unwrap(site): java.lang.String)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .state(state.unwrap)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          DestinationAdditionalFixedProperties.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.GetDestinationResponse.ReadOnly =
    zio.aws.iotroborunner.model.GetDestinationResponse.wrap(buildAwsValue())
}
object GetDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.GetDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.GetDestinationResponse =
      zio.aws.iotroborunner.model.GetDestinationResponse(
        arn,
        id,
        name,
        site,
        createdAt,
        updatedAt,
        state,
        additionalFixedProperties.map(value => value)
      )
    def arn: DestinationArn
    def id: DestinationId
    def name: Name
    def site: SiteArn
    def createdAt: CreatedAtTimestamp
    def updatedAt: UpdatedAtTimestamp
    def state: zio.aws.iotroborunner.model.DestinationState
    def additionalFixedProperties
        : Optional[DestinationAdditionalFixedProperties]
    def getArn: ZIO[Any, Nothing, DestinationArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, DestinationId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSite: ZIO[Any, Nothing, SiteArn] = ZIO.succeed(site)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
    def getState
        : ZIO[Any, Nothing, zio.aws.iotroborunner.model.DestinationState] =
      ZIO.succeed(state)
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, DestinationAdditionalFixedProperties] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetDestinationResponse
  ) extends zio.aws.iotroborunner.model.GetDestinationResponse.ReadOnly {
    override val arn: DestinationArn =
      zio.aws.iotroborunner.model.primitives.DestinationArn(impl.arn())
    override val id: DestinationId =
      zio.aws.iotroborunner.model.primitives.DestinationId(impl.id())
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val site: SiteArn =
      zio.aws.iotroborunner.model.primitives.SiteArn(impl.site())
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
    override val state: zio.aws.iotroborunner.model.DestinationState =
      zio.aws.iotroborunner.model.DestinationState.wrap(impl.state())
    override val additionalFixedProperties
        : Optional[DestinationAdditionalFixedProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .DestinationAdditionalFixedProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetDestinationResponse
  ): zio.aws.iotroborunner.model.GetDestinationResponse.ReadOnly = new Wrapper(
    impl
  )
}
