package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.{
  UpdatedAtTimestamp,
  CreatedAtTimestamp,
  SiteId,
  SiteArn
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateSiteResponse(
    arn: SiteArn,
    id: SiteId,
    createdAt: CreatedAtTimestamp,
    updatedAt: UpdatedAtTimestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CreateSiteResponse = {
    import CreateSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CreateSiteResponse
      .builder()
      .arn(SiteArn.unwrap(arn): java.lang.String)
      .id(SiteId.unwrap(id): java.lang.String)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.CreateSiteResponse.ReadOnly =
    zio.aws.iotroborunner.model.CreateSiteResponse.wrap(buildAwsValue())
}
object CreateSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CreateSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CreateSiteResponse =
      zio.aws.iotroborunner.model.CreateSiteResponse(
        arn,
        id,
        createdAt,
        updatedAt
      )
    def arn: SiteArn
    def id: SiteId
    def createdAt: CreatedAtTimestamp
    def updatedAt: UpdatedAtTimestamp
    def getArn: ZIO[Any, Nothing, SiteArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, SiteId] = ZIO.succeed(id)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateSiteResponse
  ) extends zio.aws.iotroborunner.model.CreateSiteResponse.ReadOnly {
    override val arn: SiteArn =
      zio.aws.iotroborunner.model.primitives.SiteArn(impl.arn())
    override val id: SiteId =
      zio.aws.iotroborunner.model.primitives.SiteId(impl.id())
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateSiteResponse
  ): zio.aws.iotroborunner.model.CreateSiteResponse.ReadOnly = new Wrapper(impl)
}
