package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  WorkerAdditionalFixedPropertiesJson,
  WorkerAdditionalTransientPropertiesJson,
  Name,
  WorkerGenericIdentifier
}
import scala.jdk.CollectionConverters._
final case class UpdateWorkerRequest(
    id: WorkerGenericIdentifier,
    name: Optional[Name] = Optional.Absent,
    additionalTransientProperties: Optional[
      WorkerAdditionalTransientPropertiesJson
    ] = Optional.Absent,
    additionalFixedProperties: Optional[WorkerAdditionalFixedPropertiesJson] =
      Optional.Absent,
    vendorProperties: Optional[zio.aws.iotroborunner.model.VendorProperties] =
      Optional.Absent,
    position: Optional[zio.aws.iotroborunner.model.PositionCoordinates] =
      Optional.Absent,
    orientation: Optional[zio.aws.iotroborunner.model.Orientation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerRequest = {
    import UpdateWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerRequest
      .builder()
      .id(WorkerGenericIdentifier.unwrap(id): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        additionalTransientProperties.map(value =>
          WorkerAdditionalTransientPropertiesJson.unwrap(
            value
          ): java.lang.String
        )
      )(_.additionalTransientProperties)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          WorkerAdditionalFixedPropertiesJson.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .optionallyWith(vendorProperties.map(value => value.buildAwsValue()))(
        _.vendorProperties
      )
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .optionallyWith(orientation.map(value => value.buildAwsValue()))(
        _.orientation
      )
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.UpdateWorkerRequest.ReadOnly =
    zio.aws.iotroborunner.model.UpdateWorkerRequest.wrap(buildAwsValue())
}
object UpdateWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.UpdateWorkerRequest =
      zio.aws.iotroborunner.model.UpdateWorkerRequest(
        id,
        name.map(value => value),
        additionalTransientProperties.map(value => value),
        additionalFixedProperties.map(value => value),
        vendorProperties.map(value => value.asEditable),
        position.map(value => value.asEditable),
        orientation.map(value => value.asEditable)
      )
    def id: WorkerGenericIdentifier
    def name: Optional[Name]
    def additionalTransientProperties
        : Optional[WorkerAdditionalTransientPropertiesJson]
    def additionalFixedProperties: Optional[WorkerAdditionalFixedPropertiesJson]
    def vendorProperties
        : Optional[zio.aws.iotroborunner.model.VendorProperties.ReadOnly]
    def position
        : Optional[zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly]
    def orientation: Optional[zio.aws.iotroborunner.model.Orientation.ReadOnly]
    def getId: ZIO[Any, Nothing, WorkerGenericIdentifier] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getAdditionalTransientProperties
        : ZIO[Any, AwsError, WorkerAdditionalTransientPropertiesJson] =
      AwsError.unwrapOptionField(
        "additionalTransientProperties",
        additionalTransientProperties
      )
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, WorkerAdditionalFixedPropertiesJson] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
    def getVendorProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.VendorProperties.ReadOnly
    ] = AwsError.unwrapOptionField("vendorProperties", vendorProperties)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly
    ] = AwsError.unwrapOptionField("position", position)
    def getOrientation
        : ZIO[Any, AwsError, zio.aws.iotroborunner.model.Orientation.ReadOnly] =
      AwsError.unwrapOptionField("orientation", orientation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerRequest
  ) extends zio.aws.iotroborunner.model.UpdateWorkerRequest.ReadOnly {
    override val id: WorkerGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.WorkerGenericIdentifier(impl.id())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotroborunner.model.primitives.Name(value))
    override val additionalTransientProperties
        : Optional[WorkerAdditionalTransientPropertiesJson] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalTransientProperties())
        .map(value =>
          zio.aws.iotroborunner.model.primitives
            .WorkerAdditionalTransientPropertiesJson(value)
        )
    override val additionalFixedProperties
        : Optional[WorkerAdditionalFixedPropertiesJson] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .WorkerAdditionalFixedPropertiesJson(value)
      )
    override val vendorProperties
        : Optional[zio.aws.iotroborunner.model.VendorProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorProperties())
        .map(value => zio.aws.iotroborunner.model.VendorProperties.wrap(value))
    override val position
        : Optional[zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value =>
          zio.aws.iotroborunner.model.PositionCoordinates.wrap(value)
        )
    override val orientation
        : Optional[zio.aws.iotroborunner.model.Orientation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orientation())
        .map(value => zio.aws.iotroborunner.model.Orientation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerRequest
  ): zio.aws.iotroborunner.model.UpdateWorkerRequest.ReadOnly = new Wrapper(
    impl
  )
}
