package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  WorkerFleetAdditionalFixedProperties,
  Name,
  WorkerFleetGenericIdentifier
}
import scala.jdk.CollectionConverters._
final case class UpdateWorkerFleetRequest(
    id: WorkerFleetGenericIdentifier,
    name: Optional[Name] = Optional.Absent,
    additionalFixedProperties: Optional[WorkerFleetAdditionalFixedProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetRequest = {
    import UpdateWorkerFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetRequest
      .builder()
      .id(WorkerFleetGenericIdentifier.unwrap(id): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        additionalFixedProperties.map(value =>
          WorkerFleetAdditionalFixedProperties.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.UpdateWorkerFleetRequest.ReadOnly =
    zio.aws.iotroborunner.model.UpdateWorkerFleetRequest.wrap(buildAwsValue())
}
object UpdateWorkerFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.UpdateWorkerFleetRequest =
      zio.aws.iotroborunner.model.UpdateWorkerFleetRequest(
        id,
        name.map(value => value),
        additionalFixedProperties.map(value => value)
      )
    def id: WorkerFleetGenericIdentifier
    def name: Optional[Name]
    def additionalFixedProperties
        : Optional[WorkerFleetAdditionalFixedProperties]
    def getId: ZIO[Any, Nothing, WorkerFleetGenericIdentifier] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, WorkerFleetAdditionalFixedProperties] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetRequest
  ) extends zio.aws.iotroborunner.model.UpdateWorkerFleetRequest.ReadOnly {
    override val id: WorkerFleetGenericIdentifier =
      zio.aws.iotroborunner.model.primitives
        .WorkerFleetGenericIdentifier(impl.id())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotroborunner.model.primitives.Name(value))
    override val additionalFixedProperties
        : Optional[WorkerFleetAdditionalFixedProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .WorkerFleetAdditionalFixedProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetRequest
  ): zio.aws.iotroborunner.model.UpdateWorkerFleetRequest.ReadOnly =
    new Wrapper(impl)
}
