package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PositionCoordinates(
    cartesianCoordinates: Optional[
      zio.aws.iotroborunner.model.CartesianCoordinates
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.PositionCoordinates = {
    import PositionCoordinates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.PositionCoordinates
      .builder()
      .optionallyWith(cartesianCoordinates.map(value => value.buildAwsValue()))(
        _.cartesianCoordinates
      )
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly =
    zio.aws.iotroborunner.model.PositionCoordinates.wrap(buildAwsValue())
}
object PositionCoordinates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.PositionCoordinates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.PositionCoordinates =
      zio.aws.iotroborunner.model.PositionCoordinates(
        cartesianCoordinates.map(value => value.asEditable)
      )
    def cartesianCoordinates
        : Optional[zio.aws.iotroborunner.model.CartesianCoordinates.ReadOnly]
    def getCartesianCoordinates: ZIO[
      Any,
      AwsError,
      zio.aws.iotroborunner.model.CartesianCoordinates.ReadOnly
    ] = AwsError.unwrapOptionField("cartesianCoordinates", cartesianCoordinates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.PositionCoordinates
  ) extends zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly {
    override val cartesianCoordinates
        : Optional[zio.aws.iotroborunner.model.CartesianCoordinates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cartesianCoordinates())
        .map(value =>
          zio.aws.iotroborunner.model.CartesianCoordinates.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.PositionCoordinates
  ): zio.aws.iotroborunner.model.PositionCoordinates.ReadOnly = new Wrapper(
    impl
  )
}
