package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListWorkersResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    workers: Optional[Iterable[zio.aws.iotroborunner.model.Worker]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse = {
    import ListWorkersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        workers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workers)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.ListWorkersResponse.ReadOnly =
    zio.aws.iotroborunner.model.ListWorkersResponse.wrap(buildAwsValue())
}
object ListWorkersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.ListWorkersResponse =
      zio.aws.iotroborunner.model.ListWorkersResponse(
        nextToken.map(value => value),
        workers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def workers: Optional[List[zio.aws.iotroborunner.model.Worker.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkers: ZIO[Any, AwsError, List[
      zio.aws.iotroborunner.model.Worker.ReadOnly
    ]] = AwsError.unwrapOptionField("workers", workers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse
  ) extends zio.aws.iotroborunner.model.ListWorkersResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.PaginationToken(value)
      )
    override val workers
        : Optional[List[zio.aws.iotroborunner.model.Worker.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotroborunner.model.Worker.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse
  ): zio.aws.iotroborunner.model.ListWorkersResponse.ReadOnly = new Wrapper(
    impl
  )
}
