package zio.aws.iotroborunner.model
import scala.jdk.CollectionConverters._
sealed trait DestinationState {
  def unwrap
      : software.amazon.awssdk.services.iotroborunner.model.DestinationState
}
object DestinationState {
  def wrap(
      value: software.amazon.awssdk.services.iotroborunner.model.DestinationState
  ): zio.aws.iotroborunner.model.DestinationState = value match {
    case software.amazon.awssdk.services.iotroborunner.model.DestinationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotroborunner.model.DestinationState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.iotroborunner.model.DestinationState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.iotroborunner.model.DestinationState.DECOMMISSIONED =>
      val r = DECOMMISSIONED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotroborunner.model.DestinationState {
    override def unwrap
        : software.amazon.awssdk.services.iotroborunner.model.DestinationState =
      software.amazon.awssdk.services.iotroborunner.model.DestinationState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.iotroborunner.model.DestinationState {
    override def unwrap
        : software.amazon.awssdk.services.iotroborunner.model.DestinationState =
      software.amazon.awssdk.services.iotroborunner.model.DestinationState.ENABLED
  }
  case object DISABLED extends zio.aws.iotroborunner.model.DestinationState {
    override def unwrap
        : software.amazon.awssdk.services.iotroborunner.model.DestinationState =
      software.amazon.awssdk.services.iotroborunner.model.DestinationState.DISABLED
  }
  case object DECOMMISSIONED
      extends zio.aws.iotroborunner.model.DestinationState {
    override def unwrap
        : software.amazon.awssdk.services.iotroborunner.model.DestinationState =
      software.amazon.awssdk.services.iotroborunner.model.DestinationState.DECOMMISSIONED
  }
}
