package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.DestinationGenericIdentifier
import scala.jdk.CollectionConverters._
final case class DeleteDestinationRequest(id: DestinationGenericIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.DeleteDestinationRequest = {
    import DeleteDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.DeleteDestinationRequest
      .builder()
      .id(DestinationGenericIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.DeleteDestinationRequest.ReadOnly =
    zio.aws.iotroborunner.model.DeleteDestinationRequest.wrap(buildAwsValue())
}
object DeleteDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.DeleteDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.DeleteDestinationRequest =
      zio.aws.iotroborunner.model.DeleteDestinationRequest(id)
    def id: DestinationGenericIdentifier
    def getId: ZIO[Any, Nothing, DestinationGenericIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.DeleteDestinationRequest
  ) extends zio.aws.iotroborunner.model.DeleteDestinationRequest.ReadOnly {
    override val id: DestinationGenericIdentifier =
      zio.aws.iotroborunner.model.primitives
        .DestinationGenericIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.DeleteDestinationRequest
  ): zio.aws.iotroborunner.model.DeleteDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
