package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  DestinationAdditionalFixedProperties,
  SiteGenericIdentifier,
  Name,
  IdempotencyToken
}
import scala.jdk.CollectionConverters._
final case class CreateDestinationRequest(
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    name: Name,
    site: SiteGenericIdentifier,
    state: Optional[zio.aws.iotroborunner.model.DestinationState] =
      Optional.Absent,
    additionalFixedProperties: Optional[DestinationAdditionalFixedProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CreateDestinationRequest = {
    import CreateDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CreateDestinationRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .name(Name.unwrap(name): java.lang.String)
      .site(SiteGenericIdentifier.unwrap(site): java.lang.String)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        additionalFixedProperties.map(value =>
          DestinationAdditionalFixedProperties.unwrap(value): java.lang.String
        )
      )(_.additionalFixedProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.CreateDestinationRequest.ReadOnly =
    zio.aws.iotroborunner.model.CreateDestinationRequest.wrap(buildAwsValue())
}
object CreateDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CreateDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CreateDestinationRequest =
      zio.aws.iotroborunner.model.CreateDestinationRequest(
        clientToken.map(value => value),
        name,
        site,
        state.map(value => value),
        additionalFixedProperties.map(value => value)
      )
    def clientToken: Optional[IdempotencyToken]
    def name: Name
    def site: SiteGenericIdentifier
    def state: Optional[zio.aws.iotroborunner.model.DestinationState]
    def additionalFixedProperties
        : Optional[DestinationAdditionalFixedProperties]
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSite: ZIO[Any, Nothing, SiteGenericIdentifier] = ZIO.succeed(site)
    def getState
        : ZIO[Any, AwsError, zio.aws.iotroborunner.model.DestinationState] =
      AwsError.unwrapOptionField("state", state)
    def getAdditionalFixedProperties
        : ZIO[Any, AwsError, DestinationAdditionalFixedProperties] = AwsError
      .unwrapOptionField("additionalFixedProperties", additionalFixedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateDestinationRequest
  ) extends zio.aws.iotroborunner.model.CreateDestinationRequest.ReadOnly {
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.IdempotencyToken(value)
      )
    override val name: Name =
      zio.aws.iotroborunner.model.primitives.Name(impl.name())
    override val site: SiteGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier(impl.site())
    override val state: Optional[zio.aws.iotroborunner.model.DestinationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iotroborunner.model.DestinationState.wrap(value))
    override val additionalFixedProperties
        : Optional[DestinationAdditionalFixedProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .DestinationAdditionalFixedProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateDestinationRequest
  ): zio.aws.iotroborunner.model.CreateDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
