package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  ThingName,
  DetailsValue,
  ExecutionNumber,
  ExpectedVersion,
  IncludeExecutionState,
  DetailsKey,
  IncludeJobDocument,
  StepTimeoutInMinutes,
  JobId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateJobExecutionRequest(
    jobId: JobId,
    thingName: ThingName,
    status: zio.aws.iotjobsdataplane.model.JobExecutionStatus,
    statusDetails: Optional[Map[DetailsKey, DetailsValue]] = Optional.Absent,
    stepTimeoutInMinutes: Optional[StepTimeoutInMinutes] = Optional.Absent,
    expectedVersion: Optional[ExpectedVersion] = Optional.Absent,
    includeJobExecutionState: Optional[IncludeExecutionState] = Optional.Absent,
    includeJobDocument: Optional[IncludeJobDocument] = Optional.Absent,
    executionNumber: Optional[ExecutionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest = {
    import UpdateJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusDetails.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.statusDetails)
      .optionallyWith(
        stepTimeoutInMinutes.map(value =>
          StepTimeoutInMinutes.unwrap(value): java.lang.Long
        )
      )(_.stepTimeoutInMinutes)
      .optionallyWith(
        expectedVersion.map(value =>
          ExpectedVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .optionallyWith(
        includeJobExecutionState.map(value =>
          IncludeExecutionState.unwrap(value): java.lang.Boolean
        )
      )(_.includeJobExecutionState)
      .optionallyWith(
        includeJobDocument.map(value =>
          IncludeJobDocument.unwrap(value): java.lang.Boolean
        )
      )(_.includeJobDocument)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest.ReadOnly =
    zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest
      .wrap(buildAwsValue())
}
object UpdateJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest =
      zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest(
        jobId,
        thingName,
        status,
        statusDetails.map(value => value),
        stepTimeoutInMinutes.map(value => value),
        expectedVersion.map(value => value),
        includeJobExecutionState.map(value => value),
        includeJobDocument.map(value => value),
        executionNumber.map(value => value)
      )
    def jobId: JobId
    def thingName: ThingName
    def status: zio.aws.iotjobsdataplane.model.JobExecutionStatus
    def statusDetails: Optional[Map[DetailsKey, DetailsValue]]
    def stepTimeoutInMinutes: Optional[StepTimeoutInMinutes]
    def expectedVersion: Optional[ExpectedVersion]
    def includeJobExecutionState: Optional[IncludeExecutionState]
    def includeJobDocument: Optional[IncludeJobDocument]
    def executionNumber: Optional[ExecutionNumber]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iotjobsdataplane.model.JobExecutionStatus] =
      ZIO.succeed(status)
    def getStatusDetails: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStepTimeoutInMinutes: ZIO[Any, AwsError, StepTimeoutInMinutes] =
      AwsError.unwrapOptionField("stepTimeoutInMinutes", stepTimeoutInMinutes)
    def getExpectedVersion: ZIO[Any, AwsError, ExpectedVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
    def getIncludeJobExecutionState: ZIO[Any, AwsError, IncludeExecutionState] =
      AwsError.unwrapOptionField(
        "includeJobExecutionState",
        includeJobExecutionState
      )
    def getIncludeJobDocument: ZIO[Any, AwsError, IncludeJobDocument] =
      AwsError.unwrapOptionField("includeJobDocument", includeJobDocument)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest
  ) extends zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.iotjobsdataplane.model.primitives.JobId(impl.jobId())
    override val thingName: ThingName =
      zio.aws.iotjobsdataplane.model.primitives.ThingName(impl.thingName())
    override val status: zio.aws.iotjobsdataplane.model.JobExecutionStatus =
      zio.aws.iotjobsdataplane.model.JobExecutionStatus.wrap(impl.status())
    override val statusDetails: Optional[Map[DetailsKey, DetailsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotjobsdataplane.model.primitives.DetailsKey(
                key
              ) -> zio.aws.iotjobsdataplane.model.primitives.DetailsValue(value)
            })
            .toMap
        )
    override val stepTimeoutInMinutes: Optional[StepTimeoutInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepTimeoutInMinutes())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.StepTimeoutInMinutes(value)
        )
    override val expectedVersion: Optional[ExpectedVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.ExpectedVersion(value)
        )
    override val includeJobExecutionState: Optional[IncludeExecutionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeJobExecutionState())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.IncludeExecutionState(value)
        )
    override val includeJobDocument: Optional[IncludeJobDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeJobDocument())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.IncludeJobDocument(value)
        )
    override val executionNumber: Optional[ExecutionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionNumber())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.ExecutionNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest
  ): zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
