package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  ThingName,
  DetailsValue,
  ApproximateSecondsBeforeTimedOut,
  JobDocument,
  ExecutionNumber,
  VersionNumber,
  DetailsKey,
  JobId,
  StartedAt,
  LastUpdatedAt,
  QueuedAt
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobExecution(
    jobId: Optional[JobId] = Optional.Absent,
    thingName: Optional[ThingName] = Optional.Absent,
    status: Optional[zio.aws.iotjobsdataplane.model.JobExecutionStatus] =
      Optional.Absent,
    statusDetails: Optional[Map[DetailsKey, DetailsValue]] = Optional.Absent,
    queuedAt: Optional[QueuedAt] = Optional.Absent,
    startedAt: Optional[StartedAt] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    approximateSecondsBeforeTimedOut: Optional[
      ApproximateSecondsBeforeTimedOut
    ] = Optional.Absent,
    versionNumber: Optional[VersionNumber] = Optional.Absent,
    executionNumber: Optional[ExecutionNumber] = Optional.Absent,
    jobDocument: Optional[JobDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution = {
    import JobExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.statusDetails)
      .optionallyWith(
        queuedAt.map(value => QueuedAt.unwrap(value): java.lang.Long)
      )(_.queuedAt)
      .optionallyWith(
        startedAt.map(value => StartedAt.unwrap(value): java.lang.Long)
      )(_.startedAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): java.lang.Long)
      )(_.lastUpdatedAt)
      .optionallyWith(
        approximateSecondsBeforeTimedOut.map(value =>
          ApproximateSecondsBeforeTimedOut.unwrap(value): java.lang.Long
        )
      )(_.approximateSecondsBeforeTimedOut)
      .optionallyWith(
        versionNumber.map(value => VersionNumber.unwrap(value): java.lang.Long)
      )(_.versionNumber)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .optionallyWith(
        jobDocument.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.jobDocument)
      .build()
  }
  def asReadOnly: zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly =
    zio.aws.iotjobsdataplane.model.JobExecution.wrap(buildAwsValue())
}
object JobExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.JobExecution =
      zio.aws.iotjobsdataplane.model.JobExecution(
        jobId.map(value => value),
        thingName.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        queuedAt.map(value => value),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        approximateSecondsBeforeTimedOut.map(value => value),
        versionNumber.map(value => value),
        executionNumber.map(value => value),
        jobDocument.map(value => value)
      )
    def jobId: Optional[JobId]
    def thingName: Optional[ThingName]
    def status: Optional[zio.aws.iotjobsdataplane.model.JobExecutionStatus]
    def statusDetails: Optional[Map[DetailsKey, DetailsValue]]
    def queuedAt: Optional[QueuedAt]
    def startedAt: Optional[StartedAt]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def approximateSecondsBeforeTimedOut
        : Optional[ApproximateSecondsBeforeTimedOut]
    def versionNumber: Optional[VersionNumber]
    def executionNumber: Optional[ExecutionNumber]
    def jobDocument: Optional[JobDocument]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotjobsdataplane.model.JobExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getQueuedAt: ZIO[Any, AwsError, QueuedAt] =
      AwsError.unwrapOptionField("queuedAt", queuedAt)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getApproximateSecondsBeforeTimedOut
        : ZIO[Any, AwsError, ApproximateSecondsBeforeTimedOut] =
      AwsError.unwrapOptionField(
        "approximateSecondsBeforeTimedOut",
        approximateSecondsBeforeTimedOut
      )
    def getVersionNumber: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
    def getJobDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("jobDocument", jobDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution
  ) extends zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.JobId(value))
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.ThingName(value))
    override val status
        : Optional[zio.aws.iotjobsdataplane.model.JobExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotjobsdataplane.model.JobExecutionStatus.wrap(value)
        )
    override val statusDetails: Optional[Map[DetailsKey, DetailsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotjobsdataplane.model.primitives.DetailsKey(
                key
              ) -> zio.aws.iotjobsdataplane.model.primitives.DetailsValue(value)
            })
            .toMap
        )
    override val queuedAt: Optional[QueuedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.queuedAt())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.QueuedAt(value))
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.StartedAt(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.LastUpdatedAt(value)
      )
    override val approximateSecondsBeforeTimedOut
        : Optional[ApproximateSecondsBeforeTimedOut] = zio.aws.core.internal
      .optionalFromNullable(impl.approximateSecondsBeforeTimedOut())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives
          .ApproximateSecondsBeforeTimedOut(value)
      )
    override val versionNumber: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.versionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.VersionNumber(value)
      )
    override val executionNumber: Optional[ExecutionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionNumber())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.ExecutionNumber(value)
        )
    override val jobDocument: Optional[JobDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.jobDocument())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.JobDocument(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution
  ): zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly = new Wrapper(impl)
}
