package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  ExecutionNumber,
  IncludeJobDocument,
  ThingName,
  DescribeJobExecutionJobId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeJobExecutionRequest(
    jobId: DescribeJobExecutionJobId,
    thingName: ThingName,
    includeJobDocument: Optional[IncludeJobDocument] = Optional.Absent,
    executionNumber: Optional[ExecutionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest = {
    import DescribeJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest
      .builder()
      .jobId(DescribeJobExecutionJobId.unwrap(jobId): java.lang.String)
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        includeJobDocument.map(value =>
          IncludeJobDocument.unwrap(value): java.lang.Boolean
        )
      )(_.includeJobDocument)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest.ReadOnly =
    zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest
      .wrap(buildAwsValue())
}
object DescribeJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest =
      zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest(
        jobId,
        thingName,
        includeJobDocument.map(value => value),
        executionNumber.map(value => value)
      )
    def jobId: DescribeJobExecutionJobId
    def thingName: ThingName
    def includeJobDocument: Optional[IncludeJobDocument]
    def executionNumber: Optional[ExecutionNumber]
    def getJobId: ZIO[Any, Nothing, DescribeJobExecutionJobId] =
      ZIO.succeed(jobId)
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getIncludeJobDocument: ZIO[Any, AwsError, IncludeJobDocument] =
      AwsError.unwrapOptionField("includeJobDocument", includeJobDocument)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest
  ) extends zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest.ReadOnly {
    override val jobId: DescribeJobExecutionJobId =
      zio.aws.iotjobsdataplane.model.primitives
        .DescribeJobExecutionJobId(impl.jobId())
    override val thingName: ThingName =
      zio.aws.iotjobsdataplane.model.primitives.ThingName(impl.thingName())
    override val includeJobDocument: Optional[IncludeJobDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeJobDocument())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.IncludeJobDocument(value)
        )
    override val executionNumber: Optional[ExecutionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionNumber())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.ExecutionNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest
  ): zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
