package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.JobDocument
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateJobExecutionResponse(
    executionState: Optional[zio.aws.iotjobsdataplane.model.JobExecutionState] =
      Optional.Absent,
    jobDocument: Optional[JobDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse = {
    import UpdateJobExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse
      .builder()
      .optionallyWith(executionState.map(value => value.buildAwsValue()))(
        _.executionState
      )
      .optionallyWith(
        jobDocument.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.jobDocument)
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.ReadOnly =
    zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse
      .wrap(buildAwsValue())
}
object UpdateJobExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse =
      zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse(
        executionState.map(value => value.asEditable),
        jobDocument.map(value => value)
      )
    def executionState
        : Optional[zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly]
    def jobDocument: Optional[JobDocument]
    def getExecutionState: ZIO[
      Any,
      AwsError,
      zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly
    ] = AwsError.unwrapOptionField("executionState", executionState)
    def getJobDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("jobDocument", jobDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse
  ) extends zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.ReadOnly {
    override val executionState
        : Optional[zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionState())
        .map(value =>
          zio.aws.iotjobsdataplane.model.JobExecutionState.wrap(value)
        )
    override val jobDocument: Optional[JobDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.jobDocument())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.JobDocument(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse
  ): zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
