package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  VersionNumber,
  DetailsValue,
  DetailsKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobExecutionState(
    status: Optional[zio.aws.iotjobsdataplane.model.JobExecutionStatus] =
      Optional.Absent,
    statusDetails: Optional[Map[DetailsKey, DetailsValue]] = Optional.Absent,
    versionNumber: Optional[VersionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState = {
    import JobExecutionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.statusDetails)
      .optionallyWith(
        versionNumber.map(value => VersionNumber.unwrap(value): java.lang.Long)
      )(_.versionNumber)
      .build()
  }
  def asReadOnly: zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly =
    zio.aws.iotjobsdataplane.model.JobExecutionState.wrap(buildAwsValue())
}
object JobExecutionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.JobExecutionState =
      zio.aws.iotjobsdataplane.model.JobExecutionState(
        status.map(value => value),
        statusDetails.map(value => value),
        versionNumber.map(value => value)
      )
    def status: Optional[zio.aws.iotjobsdataplane.model.JobExecutionStatus]
    def statusDetails: Optional[Map[DetailsKey, DetailsValue]]
    def versionNumber: Optional[VersionNumber]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotjobsdataplane.model.JobExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getVersionNumber: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState
  ) extends zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly {
    override val status
        : Optional[zio.aws.iotjobsdataplane.model.JobExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotjobsdataplane.model.JobExecutionStatus.wrap(value)
        )
    override val statusDetails: Optional[Map[DetailsKey, DetailsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotjobsdataplane.model.primitives.DetailsKey(
                key
              ) -> zio.aws.iotjobsdataplane.model.primitives.DetailsValue(value)
            })
            .toMap
        )
    override val versionNumber: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.versionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.VersionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState
  ): zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly = new Wrapper(
    impl
  )
}
