package zio.aws.iotjobsdataplane.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartNextPendingJobExecutionResponse(
    execution: Optional[zio.aws.iotjobsdataplane.model.JobExecution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse = {
    import StartNextPendingJobExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse
      .builder()
      .optionallyWith(execution.map(value => value.buildAwsValue()))(
        _.execution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.ReadOnly =
    zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse
      .wrap(buildAwsValue())
}
object StartNextPendingJobExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse =
      zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse(
        execution.map(value => value.asEditable)
      )
    def execution
        : Optional[zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly]
    def getExecution: ZIO[
      Any,
      AwsError,
      zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly
    ] = AwsError.unwrapOptionField("execution", execution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse
  ) extends zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.ReadOnly {
    override val execution
        : Optional[zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.execution())
        .map(value => zio.aws.iotjobsdataplane.model.JobExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse
  ): zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
