package zio.aws.iotjobsdataplane
import zio.mock.{Proxy, Mock}
import zio.aws.iotjobsdataplane.model.{
  UpdateJobExecutionRequest,
  StartNextPendingJobExecutionRequest,
  GetPendingJobExecutionsRequest,
  DescribeJobExecutionRequest
}
import zio.aws.iotjobsdataplane.model.DescribeJobExecutionResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.iotjobsdataplane.IotJobsDataPlaneAsyncClient
object IotJobsDataPlaneMock extends Mock[IotJobsDataPlane] {
  object DescribeJobExecution
      extends Effect[DescribeJobExecutionRequest, AwsError, ReadOnly]
  object GetPendingJobExecutions
      extends Effect[
        GetPendingJobExecutionsRequest,
        AwsError,
        zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly
      ]
  object StartNextPendingJobExecution
      extends Effect[
        StartNextPendingJobExecutionRequest,
        AwsError,
        zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.ReadOnly
      ]
  object UpdateJobExecution
      extends Effect[
        UpdateJobExecutionRequest,
        AwsError,
        zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IotJobsDataPlane] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IotJobsDataPlane] { rts =>
        zio.ZIO.succeed {
          new IotJobsDataPlane {
            val api: IotJobsDataPlaneAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IotJobsDataPlane = this
            def describeJobExecution(
                request: DescribeJobExecutionRequest
            ): IO[AwsError, ReadOnly] = proxy(DescribeJobExecution, request)
            def getPendingJobExecutions(
                request: GetPendingJobExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly
            ] = proxy(GetPendingJobExecutions, request)
            def startNextPendingJobExecution(
                request: StartNextPendingJobExecutionRequest
            ): IO[
              AwsError,
              zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.ReadOnly
            ] = proxy(StartNextPendingJobExecution, request)
            def updateJobExecution(request: UpdateJobExecutionRequest): IO[
              AwsError,
              zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.ReadOnly
            ] = proxy(UpdateJobExecution, request)
          }
        }
      }
    }
  }
}
