package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  ExecutionNumber,
  VersionNumber,
  JobId,
  StartedAt,
  LastUpdatedAt,
  QueuedAt
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobExecutionSummary(
    jobId: Optional[JobId] = Optional.Absent,
    queuedAt: Optional[QueuedAt] = Optional.Absent,
    startedAt: Optional[StartedAt] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    versionNumber: Optional[VersionNumber] = Optional.Absent,
    executionNumber: Optional[ExecutionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary = {
    import JobExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        queuedAt.map(value => QueuedAt.unwrap(value): java.lang.Long)
      )(_.queuedAt)
      .optionallyWith(
        startedAt.map(value => StartedAt.unwrap(value): java.lang.Long)
      )(_.startedAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): java.lang.Long)
      )(_.lastUpdatedAt)
      .optionallyWith(
        versionNumber.map(value => VersionNumber.unwrap(value): java.lang.Long)
      )(_.versionNumber)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .build()
  }
  def asReadOnly: zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly =
    zio.aws.iotjobsdataplane.model.JobExecutionSummary.wrap(buildAwsValue())
}
object JobExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.JobExecutionSummary =
      zio.aws.iotjobsdataplane.model.JobExecutionSummary(
        jobId.map(value => value),
        queuedAt.map(value => value),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        versionNumber.map(value => value),
        executionNumber.map(value => value)
      )
    def jobId: Optional[JobId]
    def queuedAt: Optional[QueuedAt]
    def startedAt: Optional[StartedAt]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def versionNumber: Optional[VersionNumber]
    def executionNumber: Optional[ExecutionNumber]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getQueuedAt: ZIO[Any, AwsError, QueuedAt] =
      AwsError.unwrapOptionField("queuedAt", queuedAt)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getVersionNumber: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary
  ) extends zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.JobId(value))
    override val queuedAt: Optional[QueuedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.queuedAt())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.QueuedAt(value))
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.StartedAt(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.LastUpdatedAt(value)
      )
    override val versionNumber: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.versionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.VersionNumber(value)
      )
    override val executionNumber: Optional[ExecutionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionNumber())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.ExecutionNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary
  ): zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly = new Wrapper(
    impl
  )
}
