package zio.aws.iotjobsdataplane.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeJobExecutionResponse(
    execution: Optional[zio.aws.iotjobsdataplane.model.JobExecution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse = {
    import DescribeJobExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse
      .builder()
      .optionallyWith(execution.map(value => value.buildAwsValue()))(
        _.execution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.DescribeJobExecutionResponse.ReadOnly =
    zio.aws.iotjobsdataplane.model.DescribeJobExecutionResponse
      .wrap(buildAwsValue())
}
object DescribeJobExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotjobsdataplane.model.DescribeJobExecutionResponse =
      zio.aws.iotjobsdataplane.model
        .DescribeJobExecutionResponse(execution.map(value => value.asEditable))
    def execution
        : Optional[zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly]
    def getExecution: ZIO[
      Any,
      AwsError,
      zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly
    ] = AwsError.unwrapOptionField("execution", execution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse
  ) extends zio.aws.iotjobsdataplane.model.DescribeJobExecutionResponse.ReadOnly {
    override val execution
        : Optional[zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.execution())
        .map(value => zio.aws.iotjobsdataplane.model.JobExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse
  ): zio.aws.iotjobsdataplane.model.DescribeJobExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
