package zio.aws.iotjobsdataplane.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPendingJobExecutionsResponse(
    inProgressJobs: Optional[
      Iterable[zio.aws.iotjobsdataplane.model.JobExecutionSummary]
    ] = Optional.Absent,
    queuedJobs: Optional[
      Iterable[zio.aws.iotjobsdataplane.model.JobExecutionSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse = {
    import GetPendingJobExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse
      .builder()
      .optionallyWith(
        inProgressJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inProgressJobs)
      .optionallyWith(
        queuedJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queuedJobs)
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly =
    zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse
      .wrap(buildAwsValue())
}
object GetPendingJobExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse =
      zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse(
        inProgressJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queuedJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inProgressJobs: Optional[
      List[zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly]
    ]
    def queuedJobs: Optional[
      List[zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly]
    ]
    def getInProgressJobs: ZIO[Any, AwsError, List[
      zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("inProgressJobs", inProgressJobs)
    def getQueuedJobs: ZIO[Any, AwsError, List[
      zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("queuedJobs", queuedJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse
  ) extends zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly {
    override val inProgressJobs: Optional[
      List[zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inProgressJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotjobsdataplane.model.JobExecutionSummary.wrap(item)
        }.toList
      )
    override val queuedJobs: Optional[
      List[zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.queuedJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotjobsdataplane.model.JobExecutionSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse
  ): zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
