package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  StepTimeoutInMinutes,
  DetailsValue,
  DetailsKey,
  ThingName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartNextPendingJobExecutionRequest(
    thingName: ThingName,
    statusDetails: Optional[Map[DetailsKey, DetailsValue]] = Optional.Absent,
    stepTimeoutInMinutes: Optional[StepTimeoutInMinutes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest = {
    import StartNextPendingJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        statusDetails.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.statusDetails)
      .optionallyWith(
        stepTimeoutInMinutes.map(value =>
          StepTimeoutInMinutes.unwrap(value): java.lang.Long
        )
      )(_.stepTimeoutInMinutes)
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest.ReadOnly =
    zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest
      .wrap(buildAwsValue())
}
object StartNextPendingJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest =
      zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest(
        thingName,
        statusDetails.map(value => value),
        stepTimeoutInMinutes.map(value => value)
      )
    def thingName: ThingName
    def statusDetails: Optional[Map[DetailsKey, DetailsValue]]
    def stepTimeoutInMinutes: Optional[StepTimeoutInMinutes]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getStatusDetails: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStepTimeoutInMinutes: ZIO[Any, AwsError, StepTimeoutInMinutes] =
      AwsError.unwrapOptionField("stepTimeoutInMinutes", stepTimeoutInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest
  ) extends zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iotjobsdataplane.model.primitives.ThingName(impl.thingName())
    override val statusDetails: Optional[Map[DetailsKey, DetailsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotjobsdataplane.model.primitives.DetailsKey(
                key
              ) -> zio.aws.iotjobsdataplane.model.primitives.DetailsValue(value)
            })
            .toMap
        )
    override val stepTimeoutInMinutes: Optional[StepTimeoutInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepTimeoutInMinutes())
        .map(value =>
          zio.aws.iotjobsdataplane.model.primitives.StepTimeoutInMinutes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest
  ): zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
