package zio.aws.iotjobsdataplane.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPendingJobExecutionsResponse(
    inProgressJobs: Option[
      Iterable[zio.aws.iotjobsdataplane.model.JobExecutionSummary]
    ] = None,
    queuedJobs: Option[
      Iterable[zio.aws.iotjobsdataplane.model.JobExecutionSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse = {
    import GetPendingJobExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse
      .builder()
      .optionallyWith(
        inProgressJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inProgressJobs)
      .optionallyWith(
        queuedJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queuedJobs)
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly =
    zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse
      .wrap(buildAwsValue())
}
object GetPendingJobExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse =
      zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse(
        inProgressJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queuedJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inProgressJobs: Option[
      List[zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly]
    ]
    def queuedJobs: Option[
      List[zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly]
    ]
    def getInProgressJobs: ZIO[Any, AwsError, List[
      zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("inProgressJobs", inProgressJobs)
    def getQueuedJobs: ZIO[Any, AwsError, List[
      zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("queuedJobs", queuedJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse
  ) extends zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly {
    override val inProgressJobs: Option[
      List[zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly]
    ] = scala
      .Option(impl.inProgressJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotjobsdataplane.model.JobExecutionSummary.wrap(item)
        }.toList
      )
    override val queuedJobs: Option[
      List[zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly]
    ] = scala
      .Option(impl.queuedJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotjobsdataplane.model.JobExecutionSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse
  ): zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
