package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  ExecutionNumber,
  VersionNumber,
  JobId,
  StartedAt,
  LastUpdatedAt,
  QueuedAt
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobExecutionSummary(
    jobId: Option[JobId] = None,
    queuedAt: Option[QueuedAt] = None,
    startedAt: Option[StartedAt] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None,
    versionNumber: Option[VersionNumber] = None,
    executionNumber: Option[ExecutionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary = {
    import JobExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        queuedAt.map(value => QueuedAt.unwrap(value): java.lang.Long)
      )(_.queuedAt)
      .optionallyWith(
        startedAt.map(value => StartedAt.unwrap(value): java.lang.Long)
      )(_.startedAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): java.lang.Long)
      )(_.lastUpdatedAt)
      .optionallyWith(
        versionNumber.map(value => VersionNumber.unwrap(value): java.lang.Long)
      )(_.versionNumber)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .build()
  }
  def asReadOnly: zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly =
    zio.aws.iotjobsdataplane.model.JobExecutionSummary.wrap(buildAwsValue())
}
object JobExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.JobExecutionSummary =
      zio.aws.iotjobsdataplane.model.JobExecutionSummary(
        jobId.map(value => value),
        queuedAt.map(value => value),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        versionNumber.map(value => value),
        executionNumber.map(value => value)
      )
    def jobId: Option[JobId]
    def queuedAt: Option[QueuedAt]
    def startedAt: Option[StartedAt]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def versionNumber: Option[VersionNumber]
    def executionNumber: Option[ExecutionNumber]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getQueuedAt: ZIO[Any, AwsError, QueuedAt] =
      AwsError.unwrapOptionField("queuedAt", queuedAt)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getVersionNumber: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary
  ) extends zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.JobId(value))
    override val queuedAt: Option[QueuedAt] = scala
      .Option(impl.queuedAt())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.QueuedAt(value))
    override val startedAt: Option[StartedAt] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.StartedAt(value))
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.LastUpdatedAt(value)
      )
    override val versionNumber: Option[VersionNumber] = scala
      .Option(impl.versionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.VersionNumber(value)
      )
    override val executionNumber: Option[ExecutionNumber] = scala
      .Option(impl.executionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.ExecutionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary
  ): zio.aws.iotjobsdataplane.model.JobExecutionSummary.ReadOnly = new Wrapper(
    impl
  )
}
