package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  VersionNumber,
  DetailsValue,
  DetailsKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobExecutionState(
    status: Option[zio.aws.iotjobsdataplane.model.JobExecutionStatus] = None,
    statusDetails: Option[Map[DetailsKey, DetailsValue]] = None,
    versionNumber: Option[VersionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState = {
    import JobExecutionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.statusDetails)
      .optionallyWith(
        versionNumber.map(value => VersionNumber.unwrap(value): java.lang.Long)
      )(_.versionNumber)
      .build()
  }
  def asReadOnly: zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly =
    zio.aws.iotjobsdataplane.model.JobExecutionState.wrap(buildAwsValue())
}
object JobExecutionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.JobExecutionState =
      zio.aws.iotjobsdataplane.model.JobExecutionState(
        status.map(value => value),
        statusDetails.map(value => value),
        versionNumber.map(value => value)
      )
    def status: Option[zio.aws.iotjobsdataplane.model.JobExecutionStatus]
    def statusDetails: Option[Map[DetailsKey, DetailsValue]]
    def versionNumber: Option[VersionNumber]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotjobsdataplane.model.JobExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getVersionNumber: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState
  ) extends zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly {
    override val status
        : Option[zio.aws.iotjobsdataplane.model.JobExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.iotjobsdataplane.model.JobExecutionStatus.wrap(value)
      )
    override val statusDetails: Option[Map[DetailsKey, DetailsValue]] = scala
      .Option(impl.statusDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotjobsdataplane.model.primitives.DetailsKey(
              key
            ) -> zio.aws.iotjobsdataplane.model.primitives.DetailsValue(value)
          })
          .toMap
      )
    override val versionNumber: Option[VersionNumber] = scala
      .Option(impl.versionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.VersionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionState
  ): zio.aws.iotjobsdataplane.model.JobExecutionState.ReadOnly = new Wrapper(
    impl
  )
}
