package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  ThingName,
  DetailsValue,
  ExecutionNumber,
  ExpectedVersion,
  IncludeExecutionState,
  DetailsKey,
  IncludeJobDocument,
  StepTimeoutInMinutes,
  JobId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateJobExecutionRequest(
    jobId: JobId,
    thingName: ThingName,
    status: zio.aws.iotjobsdataplane.model.JobExecutionStatus,
    statusDetails: Option[Map[DetailsKey, DetailsValue]] = None,
    stepTimeoutInMinutes: Option[StepTimeoutInMinutes] = None,
    expectedVersion: Option[ExpectedVersion] = None,
    includeJobExecutionState: Option[IncludeExecutionState] = None,
    includeJobDocument: Option[IncludeJobDocument] = None,
    executionNumber: Option[ExecutionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest = {
    import UpdateJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusDetails.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.statusDetails)
      .optionallyWith(
        stepTimeoutInMinutes.map(value =>
          StepTimeoutInMinutes.unwrap(value): java.lang.Long
        )
      )(_.stepTimeoutInMinutes)
      .optionallyWith(
        expectedVersion.map(value =>
          ExpectedVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .optionallyWith(
        includeJobExecutionState.map(value =>
          IncludeExecutionState.unwrap(value): java.lang.Boolean
        )
      )(_.includeJobExecutionState)
      .optionallyWith(
        includeJobDocument.map(value =>
          IncludeJobDocument.unwrap(value): java.lang.Boolean
        )
      )(_.includeJobDocument)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .build()
  }
  def asReadOnly
      : zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest.ReadOnly =
    zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest
      .wrap(buildAwsValue())
}
object UpdateJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest =
      zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest(
        jobId,
        thingName,
        status,
        statusDetails.map(value => value),
        stepTimeoutInMinutes.map(value => value),
        expectedVersion.map(value => value),
        includeJobExecutionState.map(value => value),
        includeJobDocument.map(value => value),
        executionNumber.map(value => value)
      )
    def jobId: JobId
    def thingName: ThingName
    def status: zio.aws.iotjobsdataplane.model.JobExecutionStatus
    def statusDetails: Option[Map[DetailsKey, DetailsValue]]
    def stepTimeoutInMinutes: Option[StepTimeoutInMinutes]
    def expectedVersion: Option[ExpectedVersion]
    def includeJobExecutionState: Option[IncludeExecutionState]
    def includeJobDocument: Option[IncludeJobDocument]
    def executionNumber: Option[ExecutionNumber]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iotjobsdataplane.model.JobExecutionStatus] =
      ZIO.succeed(status)
    def getStatusDetails: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStepTimeoutInMinutes: ZIO[Any, AwsError, StepTimeoutInMinutes] =
      AwsError.unwrapOptionField("stepTimeoutInMinutes", stepTimeoutInMinutes)
    def getExpectedVersion: ZIO[Any, AwsError, ExpectedVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
    def getIncludeJobExecutionState: ZIO[Any, AwsError, IncludeExecutionState] =
      AwsError.unwrapOptionField(
        "includeJobExecutionState",
        includeJobExecutionState
      )
    def getIncludeJobDocument: ZIO[Any, AwsError, IncludeJobDocument] =
      AwsError.unwrapOptionField("includeJobDocument", includeJobDocument)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest
  ) extends zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.iotjobsdataplane.model.primitives.JobId(impl.jobId())
    override val thingName: ThingName =
      zio.aws.iotjobsdataplane.model.primitives.ThingName(impl.thingName())
    override val status: zio.aws.iotjobsdataplane.model.JobExecutionStatus =
      zio.aws.iotjobsdataplane.model.JobExecutionStatus.wrap(impl.status())
    override val statusDetails: Option[Map[DetailsKey, DetailsValue]] = scala
      .Option(impl.statusDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotjobsdataplane.model.primitives.DetailsKey(
              key
            ) -> zio.aws.iotjobsdataplane.model.primitives.DetailsValue(value)
          })
          .toMap
      )
    override val stepTimeoutInMinutes: Option[StepTimeoutInMinutes] = scala
      .Option(impl.stepTimeoutInMinutes())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.StepTimeoutInMinutes(value)
      )
    override val expectedVersion: Option[ExpectedVersion] = scala
      .Option(impl.expectedVersion())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.ExpectedVersion(value)
      )
    override val includeJobExecutionState: Option[IncludeExecutionState] = scala
      .Option(impl.includeJobExecutionState())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.IncludeExecutionState(value)
      )
    override val includeJobDocument: Option[IncludeJobDocument] = scala
      .Option(impl.includeJobDocument())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.IncludeJobDocument(value)
      )
    override val executionNumber: Option[ExecutionNumber] = scala
      .Option(impl.executionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.ExecutionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest
  ): zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
