package zio.aws.iotjobsdataplane.model
import zio.aws.iotjobsdataplane.model.primitives.{
  ThingName,
  DetailsValue,
  ApproximateSecondsBeforeTimedOut,
  JobDocument,
  ExecutionNumber,
  VersionNumber,
  DetailsKey,
  JobId,
  StartedAt,
  LastUpdatedAt,
  QueuedAt
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobExecution(
    jobId: Option[JobId] = None,
    thingName: Option[ThingName] = None,
    status: Option[zio.aws.iotjobsdataplane.model.JobExecutionStatus] = None,
    statusDetails: Option[Map[DetailsKey, DetailsValue]] = None,
    queuedAt: Option[QueuedAt] = None,
    startedAt: Option[StartedAt] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None,
    approximateSecondsBeforeTimedOut: Option[ApproximateSecondsBeforeTimedOut] =
      None,
    versionNumber: Option[VersionNumber] = None,
    executionNumber: Option[ExecutionNumber] = None,
    jobDocument: Option[JobDocument] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution = {
    import JobExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.statusDetails)
      .optionallyWith(
        queuedAt.map(value => QueuedAt.unwrap(value): java.lang.Long)
      )(_.queuedAt)
      .optionallyWith(
        startedAt.map(value => StartedAt.unwrap(value): java.lang.Long)
      )(_.startedAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): java.lang.Long)
      )(_.lastUpdatedAt)
      .optionallyWith(
        approximateSecondsBeforeTimedOut.map(value =>
          ApproximateSecondsBeforeTimedOut.unwrap(value): java.lang.Long
        )
      )(_.approximateSecondsBeforeTimedOut)
      .optionallyWith(
        versionNumber.map(value => VersionNumber.unwrap(value): java.lang.Long)
      )(_.versionNumber)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .optionallyWith(
        jobDocument.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.jobDocument)
      .build()
  }
  def asReadOnly: zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly =
    zio.aws.iotjobsdataplane.model.JobExecution.wrap(buildAwsValue())
}
object JobExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotjobsdataplane.model.JobExecution =
      zio.aws.iotjobsdataplane.model.JobExecution(
        jobId.map(value => value),
        thingName.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        queuedAt.map(value => value),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        approximateSecondsBeforeTimedOut.map(value => value),
        versionNumber.map(value => value),
        executionNumber.map(value => value),
        jobDocument.map(value => value)
      )
    def jobId: Option[JobId]
    def thingName: Option[ThingName]
    def status: Option[zio.aws.iotjobsdataplane.model.JobExecutionStatus]
    def statusDetails: Option[Map[DetailsKey, DetailsValue]]
    def queuedAt: Option[QueuedAt]
    def startedAt: Option[StartedAt]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def approximateSecondsBeforeTimedOut
        : Option[ApproximateSecondsBeforeTimedOut]
    def versionNumber: Option[VersionNumber]
    def executionNumber: Option[ExecutionNumber]
    def jobDocument: Option[JobDocument]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotjobsdataplane.model.JobExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getQueuedAt: ZIO[Any, AwsError, QueuedAt] =
      AwsError.unwrapOptionField("queuedAt", queuedAt)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getApproximateSecondsBeforeTimedOut
        : ZIO[Any, AwsError, ApproximateSecondsBeforeTimedOut] =
      AwsError.unwrapOptionField(
        "approximateSecondsBeforeTimedOut",
        approximateSecondsBeforeTimedOut
      )
    def getVersionNumber: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
    def getJobDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("jobDocument", jobDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution
  ) extends zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.JobId(value))
    override val thingName: Option[ThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.ThingName(value))
    override val status
        : Option[zio.aws.iotjobsdataplane.model.JobExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.iotjobsdataplane.model.JobExecutionStatus.wrap(value)
      )
    override val statusDetails: Option[Map[DetailsKey, DetailsValue]] = scala
      .Option(impl.statusDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotjobsdataplane.model.primitives.DetailsKey(
              key
            ) -> zio.aws.iotjobsdataplane.model.primitives.DetailsValue(value)
          })
          .toMap
      )
    override val queuedAt: Option[QueuedAt] = scala
      .Option(impl.queuedAt())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.QueuedAt(value))
    override val startedAt: Option[StartedAt] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.iotjobsdataplane.model.primitives.StartedAt(value))
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.LastUpdatedAt(value)
      )
    override val approximateSecondsBeforeTimedOut
        : Option[ApproximateSecondsBeforeTimedOut] = scala
      .Option(impl.approximateSecondsBeforeTimedOut())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives
          .ApproximateSecondsBeforeTimedOut(value)
      )
    override val versionNumber: Option[VersionNumber] = scala
      .Option(impl.versionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.VersionNumber(value)
      )
    override val executionNumber: Option[ExecutionNumber] = scala
      .Option(impl.executionNumber())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.ExecutionNumber(value)
      )
    override val jobDocument: Option[JobDocument] = scala
      .Option(impl.jobDocument())
      .map(value =>
        zio.aws.iotjobsdataplane.model.primitives.JobDocument(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotjobsdataplane.model.JobExecution
  ): zio.aws.iotjobsdataplane.model.JobExecution.ReadOnly = new Wrapper(impl)
}
