package zio.aws.iotjobsdataplane
import software.amazon.awssdk.services.iotjobsdataplane.model.{
  StartNextPendingJobExecutionResponse,
  GetPendingJobExecutionsRequest,
  GetPendingJobExecutionsResponse,
  UpdateJobExecutionResponse,
  StartNextPendingJobExecutionRequest,
  DescribeJobExecutionRequest,
  UpdateJobExecutionRequest,
  DescribeJobExecutionResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.iotjobsdataplane.model.DescribeJobExecutionResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.iotjobsdataplane.{
  IotJobsDataPlaneAsyncClientBuilder,
  IotJobsDataPlaneAsyncClient
}
import scala.jdk.CollectionConverters._
trait IotJobsDataPlane extends AspectSupport[IotJobsDataPlane] {
  val api: IotJobsDataPlaneAsyncClient
  def describeJobExecution(
      request: zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest
  ): IO[AwsError, ReadOnly]
  def getPendingJobExecutions(
      request: zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly
  ]
  def startNextPendingJobExecution(
      request: zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest
  ): IO[
    AwsError,
    zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.ReadOnly
  ]
  def updateJobExecution(
      request: zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest
  ): IO[
    AwsError,
    zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.ReadOnly
  ]
}
object IotJobsDataPlane {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IotJobsDataPlane] =
    customized(identity)
  def customized(
      customization: IotJobsDataPlaneAsyncClientBuilder => IotJobsDataPlaneAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IotJobsDataPlane] = managed(
    customization
  ).toLayer
  def managed(
      customization: IotJobsDataPlaneAsyncClientBuilder => IotJobsDataPlaneAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, IotJobsDataPlane] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = IotJobsDataPlaneAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        IotJobsDataPlaneAsyncClient,
        IotJobsDataPlaneAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        IotJobsDataPlaneAsyncClient,
        IotJobsDataPlaneAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new IotJobsDataPlaneImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IotJobsDataPlaneImpl[R](
      override val api: IotJobsDataPlaneAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IotJobsDataPlane
      with AwsServiceBase[R] {
    override val serviceName: String = "IotJobsDataPlane"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IotJobsDataPlaneImpl[R1] = new IotJobsDataPlaneImpl(api, newAspect, r)
    def describeJobExecution(
        request: zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DescribeJobExecutionRequest,
      DescribeJobExecutionResponse
    ]("describeJobExecution", api.describeJobExecution)(request.buildAwsValue())
      .map(zio.aws.iotjobsdataplane.model.DescribeJobExecutionResponse.wrap)
      .provideEnvironment(r)
    def getPendingJobExecutions(
        request: zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPendingJobExecutionsRequest,
      GetPendingJobExecutionsResponse
    ]("getPendingJobExecutions", api.getPendingJobExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.wrap)
      .provideEnvironment(r)
    def startNextPendingJobExecution(
        request: zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest
    ): IO[
      AwsError,
      zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartNextPendingJobExecutionRequest,
      StartNextPendingJobExecutionResponse
    ]("startNextPendingJobExecution", api.startNextPendingJobExecution)(
      request.buildAwsValue()
    ).map(
      zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.wrap
    ).provideEnvironment(r)
    def updateJobExecution(
        request: zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest
    ): IO[
      AwsError,
      zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateJobExecutionRequest,
      UpdateJobExecutionResponse
    ]("updateJobExecution", api.updateJobExecution)(request.buildAwsValue())
      .map(zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.wrap)
      .provideEnvironment(r)
  }
  def describeJobExecution(
      request: zio.aws.iotjobsdataplane.model.DescribeJobExecutionRequest
  ): ZIO[zio.aws.iotjobsdataplane.IotJobsDataPlane, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeJobExecution(request))
  def getPendingJobExecutions(
      request: zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsRequest
  ): ZIO[
    zio.aws.iotjobsdataplane.IotJobsDataPlane,
    AwsError,
    zio.aws.iotjobsdataplane.model.GetPendingJobExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPendingJobExecutions(request))
  def startNextPendingJobExecution(
      request: zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionRequest
  ): ZIO[
    zio.aws.iotjobsdataplane.IotJobsDataPlane,
    AwsError,
    zio.aws.iotjobsdataplane.model.StartNextPendingJobExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startNextPendingJobExecution(request))
  def updateJobExecution(
      request: zio.aws.iotjobsdataplane.model.UpdateJobExecutionRequest
  ): ZIO[
    zio.aws.iotjobsdataplane.IotJobsDataPlane,
    AwsError,
    zio.aws.iotjobsdataplane.model.UpdateJobExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJobExecution(request))
}
