package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Prefix, S3BucketArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Config(
    bucketArn: S3BucketArn,
    dataFormat: Optional[zio.aws.iotfleetwise.model.DataFormat] =
      Optional.Absent,
    storageCompressionFormat: Optional[
      zio.aws.iotfleetwise.model.StorageCompressionFormat
    ] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.S3Config = {
    import S3Config.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.S3Config
      .builder()
      .bucketArn(S3BucketArn.unwrap(bucketArn): java.lang.String)
      .optionallyWith(dataFormat.map(value => value.unwrap))(_.dataFormat)
      .optionallyWith(storageCompressionFormat.map(value => value.unwrap))(
        _.storageCompressionFormat
      )
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.S3Config.ReadOnly =
    zio.aws.iotfleetwise.model.S3Config.wrap(buildAwsValue())
}
object S3Config {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.S3Config
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.S3Config =
      zio.aws.iotfleetwise.model.S3Config(
        bucketArn,
        dataFormat.map(value => value),
        storageCompressionFormat.map(value => value),
        prefix.map(value => value)
      )
    def bucketArn: S3BucketArn
    def dataFormat: Optional[zio.aws.iotfleetwise.model.DataFormat]
    def storageCompressionFormat
        : Optional[zio.aws.iotfleetwise.model.StorageCompressionFormat]
    def prefix: Optional[Prefix]
    def getBucketArn: ZIO[Any, Nothing, S3BucketArn] = ZIO.succeed(bucketArn)
    def getDataFormat
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.DataFormat] =
      AwsError.unwrapOptionField("dataFormat", dataFormat)
    def getStorageCompressionFormat: ZIO[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.StorageCompressionFormat
    ] = AwsError.unwrapOptionField(
      "storageCompressionFormat",
      storageCompressionFormat
    )
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.S3Config
  ) extends zio.aws.iotfleetwise.model.S3Config.ReadOnly {
    override val bucketArn: S3BucketArn =
      zio.aws.iotfleetwise.model.primitives.S3BucketArn(impl.bucketArn())
    override val dataFormat: Optional[zio.aws.iotfleetwise.model.DataFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataFormat())
        .map(value => zio.aws.iotfleetwise.model.DataFormat.wrap(value))
    override val storageCompressionFormat
        : Optional[zio.aws.iotfleetwise.model.StorageCompressionFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCompressionFormat())
        .map(value =>
          zio.aws.iotfleetwise.model.StorageCompressionFormat.wrap(value)
        )
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.iotfleetwise.model.primitives.Prefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.S3Config
  ): zio.aws.iotfleetwise.model.S3Config.ReadOnly = new Wrapper(impl)
}
