package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutEncryptionConfigurationRequest(
    kmsKeyId: Optional[String] = Optional.Absent,
    encryptionType: zio.aws.iotfleetwise.model.EncryptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest = {
    import PutEncryptionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .encryptionType(encryptionType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.PutEncryptionConfigurationRequest.ReadOnly =
    zio.aws.iotfleetwise.model.PutEncryptionConfigurationRequest
      .wrap(buildAwsValue())
}
object PutEncryptionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotfleetwise.model.PutEncryptionConfigurationRequest =
      zio.aws.iotfleetwise.model.PutEncryptionConfigurationRequest(
        kmsKeyId.map(value => value),
        encryptionType
      )
    def kmsKeyId: Optional[String]
    def encryptionType: zio.aws.iotfleetwise.model.EncryptionType
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.EncryptionType] =
      ZIO.succeed(encryptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest
  ) extends zio.aws.iotfleetwise.model.PutEncryptionConfigurationRequest.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val encryptionType: zio.aws.iotfleetwise.model.EncryptionType =
      zio.aws.iotfleetwise.model.EncryptionType.wrap(impl.encryptionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest
  ): zio.aws.iotfleetwise.model.PutEncryptionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
