package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.EncryptionType
  ): zio.aws.iotfleetwise.model.EncryptionType = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.EncryptionType.KMS_BASED_ENCRYPTION =>
      val r = KMS_BASED_ENCRYPTION
      r
    case software.amazon.awssdk.services.iotfleetwise.model.EncryptionType.FLEETWISE_DEFAULT_ENCRYPTION =>
      val r = FLEETWISE_DEFAULT_ENCRYPTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.EncryptionType =
      software.amazon.awssdk.services.iotfleetwise.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object KMS_BASED_ENCRYPTION
      extends zio.aws.iotfleetwise.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.EncryptionType =
      software.amazon.awssdk.services.iotfleetwise.model.EncryptionType.KMS_BASED_ENCRYPTION
  }
  case object FLEETWISE_DEFAULT_ENCRYPTION
      extends zio.aws.iotfleetwise.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.EncryptionType =
      software.amazon.awssdk.services.iotfleetwise.model.EncryptionType.FLEETWISE_DEFAULT_ENCRYPTION
  }
}
