package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{FleetId, VehicleName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateVehicleFleetRequest(
    vehicleName: VehicleName,
    fleetId: FleetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest = {
    import AssociateVehicleFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest
      .builder()
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.AssociateVehicleFleetRequest.ReadOnly =
    zio.aws.iotfleetwise.model.AssociateVehicleFleetRequest
      .wrap(buildAwsValue())
}
object AssociateVehicleFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.AssociateVehicleFleetRequest =
      zio.aws.iotfleetwise.model
        .AssociateVehicleFleetRequest(vehicleName, fleetId)
    def vehicleName: VehicleName
    def fleetId: FleetId
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest
  ) extends zio.aws.iotfleetwise.model.AssociateVehicleFleetRequest.ReadOnly {
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
    override val fleetId: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest
  ): zio.aws.iotfleetwise.model.AssociateVehicleFleetRequest.ReadOnly =
    new Wrapper(impl)
}
