package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{IAMRoleArn, TimestreamTableArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TimestreamConfig(
    timestreamTableArn: TimestreamTableArn,
    executionRoleArn: IAMRoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.TimestreamConfig = {
    import TimestreamConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.TimestreamConfig
      .builder()
      .timestreamTableArn(
        TimestreamTableArn.unwrap(timestreamTableArn): java.lang.String
      )
      .executionRoleArn(IAMRoleArn.unwrap(executionRoleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.TimestreamConfig.ReadOnly =
    zio.aws.iotfleetwise.model.TimestreamConfig.wrap(buildAwsValue())
}
object TimestreamConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.TimestreamConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.TimestreamConfig =
      zio.aws.iotfleetwise.model
        .TimestreamConfig(timestreamTableArn, executionRoleArn)
    def timestreamTableArn: TimestreamTableArn
    def executionRoleArn: IAMRoleArn
    def getTimestreamTableArn: ZIO[Any, Nothing, TimestreamTableArn] =
      ZIO.succeed(timestreamTableArn)
    def getExecutionRoleArn: ZIO[Any, Nothing, IAMRoleArn] =
      ZIO.succeed(executionRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.TimestreamConfig
  ) extends zio.aws.iotfleetwise.model.TimestreamConfig.ReadOnly {
    override val timestreamTableArn: TimestreamTableArn =
      zio.aws.iotfleetwise.model.primitives
        .TimestreamTableArn(impl.timestreamTableArn())
    override val executionRoleArn: IAMRoleArn =
      zio.aws.iotfleetwise.model.primitives.IAMRoleArn(impl.executionRoleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.TimestreamConfig
  ): zio.aws.iotfleetwise.model.TimestreamConfig.ReadOnly = new Wrapper(impl)
}
