package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait NodeDataType {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.NodeDataType
}
object NodeDataType {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.NodeDataType
  ): zio.aws.iotfleetwise.model.NodeDataType = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT8 =>
      val r = INT8
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT8 =>
      val r = UINT8
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT16 =>
      val r = INT16
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT16 =>
      val r = UINT16
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT32 =>
      val r = INT32
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT32 =>
      val r = UINT32
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT64 =>
      val r = INT64
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT64 =>
      val r = UINT64
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.FLOAT =>
      val r = FLOAT
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UNIX_TIMESTAMP =>
      val r = UNIX_TIMESTAMP
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT8_ARRAY =>
      val r = INT8_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT8_ARRAY =>
      val r = UINT8_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT16_ARRAY =>
      val r = INT16_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT16_ARRAY =>
      val r = UINT16_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT32_ARRAY =>
      val r = INT32_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT32_ARRAY =>
      val r = UINT32_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT64_ARRAY =>
      val r = INT64_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT64_ARRAY =>
      val r = UINT64_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.BOOLEAN_ARRAY =>
      val r = BOOLEAN_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.FLOAT_ARRAY =>
      val r = FLOAT_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.DOUBLE_ARRAY =>
      val r = DOUBLE_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.STRING_ARRAY =>
      val r = STRING_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UNIX_TIMESTAMP_ARRAY =>
      val r = UNIX_TIMESTAMP_ARRAY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object INT8 extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT8
  }
  case object UINT8 extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT8
  }
  case object INT16 extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT16
  }
  case object UINT16 extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT16
  }
  case object INT32 extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT32
  }
  case object UINT32 extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT32
  }
  case object INT64 extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT64
  }
  case object UINT64 extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT64
  }
  case object BOOLEAN extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.BOOLEAN
  }
  case object FLOAT extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.FLOAT
  }
  case object DOUBLE extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.DOUBLE
  }
  case object STRING extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.STRING
  }
  case object UNIX_TIMESTAMP extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UNIX_TIMESTAMP
  }
  case object INT8_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT8_ARRAY
  }
  case object UINT8_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT8_ARRAY
  }
  case object INT16_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT16_ARRAY
  }
  case object UINT16_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT16_ARRAY
  }
  case object INT32_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT32_ARRAY
  }
  case object UINT32_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT32_ARRAY
  }
  case object INT64_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.INT64_ARRAY
  }
  case object UINT64_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UINT64_ARRAY
  }
  case object BOOLEAN_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.BOOLEAN_ARRAY
  }
  case object FLOAT_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.FLOAT_ARRAY
  }
  case object DOUBLE_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.DOUBLE_ARRAY
  }
  case object STRING_ARRAY extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.STRING_ARRAY
  }
  case object UNIX_TIMESTAMP_ARRAY
      extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UNIX_TIMESTAMP_ARRAY
  }
  case object UNKNOWN extends zio.aws.iotfleetwise.model.NodeDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NodeDataType =
      software.amazon.awssdk.services.iotfleetwise.model.NodeDataType.UNKNOWN
  }
}
