package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportDecoderManifestRequest(
    name: ResourceName,
    networkFileDefinitions: Iterable[
      zio.aws.iotfleetwise.model.NetworkFileDefinition
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest = {
    import ImportDecoderManifestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .networkFileDefinitions(networkFileDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ImportDecoderManifestRequest.ReadOnly =
    zio.aws.iotfleetwise.model.ImportDecoderManifestRequest
      .wrap(buildAwsValue())
}
object ImportDecoderManifestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ImportDecoderManifestRequest =
      zio.aws.iotfleetwise.model.ImportDecoderManifestRequest(
        name,
        networkFileDefinitions.map { item =>
          item.asEditable
        }
      )
    def name: ResourceName
    def networkFileDefinitions
        : List[zio.aws.iotfleetwise.model.NetworkFileDefinition.ReadOnly]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getNetworkFileDefinitions: ZIO[Any, Nothing, List[
      zio.aws.iotfleetwise.model.NetworkFileDefinition.ReadOnly
    ]] = ZIO.succeed(networkFileDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest
  ) extends zio.aws.iotfleetwise.model.ImportDecoderManifestRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val networkFileDefinitions
        : List[zio.aws.iotfleetwise.model.NetworkFileDefinition.ReadOnly] = impl
      .networkFileDefinitions()
      .asScala
      .map { item =>
        zio.aws.iotfleetwise.model.NetworkFileDefinition.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest
  ): zio.aws.iotfleetwise.model.ImportDecoderManifestRequest.ReadOnly =
    new Wrapper(impl)
}
