package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Timestamp, Arn, VehicleName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class VehicleSummary(
    vehicleName: VehicleName,
    arn: Arn,
    modelManifestArn: Arn,
    decoderManifestArn: Arn,
    creationTime: Timestamp,
    lastModificationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.VehicleSummary = {
    import VehicleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.VehicleSummary
      .builder()
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .modelManifestArn(Arn.unwrap(modelManifestArn): java.lang.String)
      .decoderManifestArn(Arn.unwrap(decoderManifestArn): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModificationTime(Timestamp.unwrap(lastModificationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly =
    zio.aws.iotfleetwise.model.VehicleSummary.wrap(buildAwsValue())
}
object VehicleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.VehicleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.VehicleSummary =
      zio.aws.iotfleetwise.model.VehicleSummary(
        vehicleName,
        arn,
        modelManifestArn,
        decoderManifestArn,
        creationTime,
        lastModificationTime
      )
    def vehicleName: VehicleName
    def arn: Arn
    def modelManifestArn: Arn
    def decoderManifestArn: Arn
    def creationTime: Timestamp
    def lastModificationTime: Timestamp
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getModelManifestArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(modelManifestArn)
    def getDecoderManifestArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(decoderManifestArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModificationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.VehicleSummary
  ) extends zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly {
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
    override val modelManifestArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.modelManifestArn())
    override val decoderManifestArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.decoderManifestArn())
    override val creationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives.Timestamp(impl.creationTime())
    override val lastModificationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives
        .Timestamp(impl.lastModificationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.VehicleSummary
  ): zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly = new Wrapper(impl)
}
