package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{Timestamp, ErrorMessage}
import scala.jdk.CollectionConverters._
final case class GetEncryptionConfigurationResponse(
    kmsKeyId: Optional[String] = Optional.Absent,
    encryptionStatus: zio.aws.iotfleetwise.model.EncryptionStatus,
    encryptionType: zio.aws.iotfleetwise.model.EncryptionType,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationResponse = {
    import GetEncryptionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .encryptionStatus(encryptionStatus.unwrap)
      .encryptionType(encryptionType.unwrap)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.GetEncryptionConfigurationResponse.ReadOnly =
    zio.aws.iotfleetwise.model.GetEncryptionConfigurationResponse
      .wrap(buildAwsValue())
}
object GetEncryptionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotfleetwise.model.GetEncryptionConfigurationResponse =
      zio.aws.iotfleetwise.model.GetEncryptionConfigurationResponse(
        kmsKeyId.map(value => value),
        encryptionStatus,
        encryptionType,
        errorMessage.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def kmsKeyId: Optional[String]
    def encryptionStatus: zio.aws.iotfleetwise.model.EncryptionStatus
    def encryptionType: zio.aws.iotfleetwise.model.EncryptionType
    def errorMessage: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncryptionStatus
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.EncryptionStatus] =
      ZIO.succeed(encryptionStatus)
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.EncryptionType] =
      ZIO.succeed(encryptionType)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationResponse
  ) extends zio.aws.iotfleetwise.model.GetEncryptionConfigurationResponse.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val encryptionStatus: zio.aws.iotfleetwise.model.EncryptionStatus =
      zio.aws.iotfleetwise.model.EncryptionStatus.wrap(impl.encryptionStatus())
    override val encryptionType: zio.aws.iotfleetwise.model.EncryptionType =
      zio.aws.iotfleetwise.model.EncryptionType.wrap(impl.encryptionType())
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.iotfleetwise.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationResponse
  ): zio.aws.iotfleetwise.model.GetEncryptionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
