package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionStatus {
  def unwrap
      : software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus
}
object EncryptionStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus
  ): zio.aws.iotfleetwise.model.EncryptionStatus = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus.FAILURE =>
      val r = FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus =
      software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.iotfleetwise.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus =
      software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus.PENDING
  }
  case object SUCCESS extends zio.aws.iotfleetwise.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus =
      software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus.SUCCESS
  }
  case object FAILURE extends zio.aws.iotfleetwise.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus =
      software.amazon.awssdk.services.iotfleetwise.model.EncryptionStatus.FAILURE
  }
}
