package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchCreateVehicleRequest(
    vehicles: Iterable[zio.aws.iotfleetwise.model.CreateVehicleRequestItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest = {
    import BatchCreateVehicleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest
      .builder()
      .vehicles(vehicles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.BatchCreateVehicleRequest.ReadOnly =
    zio.aws.iotfleetwise.model.BatchCreateVehicleRequest.wrap(buildAwsValue())
}
object BatchCreateVehicleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.BatchCreateVehicleRequest =
      zio.aws.iotfleetwise.model.BatchCreateVehicleRequest(vehicles.map {
        item =>
          item.asEditable
      })
    def vehicles
        : List[zio.aws.iotfleetwise.model.CreateVehicleRequestItem.ReadOnly]
    def getVehicles: ZIO[Any, Nothing, List[
      zio.aws.iotfleetwise.model.CreateVehicleRequestItem.ReadOnly
    ]] = ZIO.succeed(vehicles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest
  ) extends zio.aws.iotfleetwise.model.BatchCreateVehicleRequest.ReadOnly {
    override val vehicles
        : List[zio.aws.iotfleetwise.model.CreateVehicleRequestItem.ReadOnly] =
      impl
        .vehicles()
        .asScala
        .map { item =>
          zio.aws.iotfleetwise.model.CreateVehicleRequestItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest
  ): zio.aws.iotfleetwise.model.BatchCreateVehicleRequest.ReadOnly =
    new Wrapper(impl)
}
