package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{InterfaceId, FullyQualifiedName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SignalDecoder(
    fullyQualifiedName: FullyQualifiedName,
    `type`: zio.aws.iotfleetwise.model.SignalDecoderType,
    interfaceId: InterfaceId,
    canSignal: Optional[zio.aws.iotfleetwise.model.CanSignal] = Optional.Absent,
    obdSignal: Optional[zio.aws.iotfleetwise.model.ObdSignal] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder = {
    import SignalDecoder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder
      .builder()
      .fullyQualifiedName(
        FullyQualifiedName.unwrap(fullyQualifiedName): java.lang.String
      )
      .`type`(`type`.unwrap)
      .interfaceId(InterfaceId.unwrap(interfaceId): java.lang.String)
      .optionallyWith(canSignal.map(value => value.buildAwsValue()))(
        _.canSignal
      )
      .optionallyWith(obdSignal.map(value => value.buildAwsValue()))(
        _.obdSignal
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly =
    zio.aws.iotfleetwise.model.SignalDecoder.wrap(buildAwsValue())
}
object SignalDecoder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.SignalDecoder =
      zio.aws.iotfleetwise.model.SignalDecoder(
        fullyQualifiedName,
        `type`,
        interfaceId,
        canSignal.map(value => value.asEditable),
        obdSignal.map(value => value.asEditable)
      )
    def fullyQualifiedName: FullyQualifiedName
    def `type`: zio.aws.iotfleetwise.model.SignalDecoderType
    def interfaceId: InterfaceId
    def canSignal: Optional[zio.aws.iotfleetwise.model.CanSignal.ReadOnly]
    def obdSignal: Optional[zio.aws.iotfleetwise.model.ObdSignal.ReadOnly]
    def getFullyQualifiedName: ZIO[Any, Nothing, FullyQualifiedName] =
      ZIO.succeed(fullyQualifiedName)
    def getType
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.SignalDecoderType] =
      ZIO.succeed(`type`)
    def getInterfaceId: ZIO[Any, Nothing, InterfaceId] =
      ZIO.succeed(interfaceId)
    def getCanSignal
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.CanSignal.ReadOnly] =
      AwsError.unwrapOptionField("canSignal", canSignal)
    def getObdSignal
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.ObdSignal.ReadOnly] =
      AwsError.unwrapOptionField("obdSignal", obdSignal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder
  ) extends zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly {
    override val fullyQualifiedName: FullyQualifiedName =
      zio.aws.iotfleetwise.model.primitives
        .FullyQualifiedName(impl.fullyQualifiedName())
    override val `type`: zio.aws.iotfleetwise.model.SignalDecoderType =
      zio.aws.iotfleetwise.model.SignalDecoderType.wrap(impl.`type`())
    override val interfaceId: InterfaceId =
      zio.aws.iotfleetwise.model.primitives.InterfaceId(impl.interfaceId())
    override val canSignal
        : Optional[zio.aws.iotfleetwise.model.CanSignal.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canSignal())
        .map(value => zio.aws.iotfleetwise.model.CanSignal.wrap(value))
    override val obdSignal
        : Optional[zio.aws.iotfleetwise.model.ObdSignal.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.obdSignal())
        .map(value => zio.aws.iotfleetwise.model.ObdSignal.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder
  ): zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly = new Wrapper(impl)
}
