package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSignalCatalogRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest = {
    import GetSignalCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetSignalCatalogRequest.ReadOnly =
    zio.aws.iotfleetwise.model.GetSignalCatalogRequest.wrap(buildAwsValue())
}
object GetSignalCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetSignalCatalogRequest =
      zio.aws.iotfleetwise.model.GetSignalCatalogRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest
  ) extends zio.aws.iotfleetwise.model.GetSignalCatalogRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest
  ): zio.aws.iotfleetwise.model.GetSignalCatalogRequest.ReadOnly = new Wrapper(
    impl
  )
}
