package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkFileDefinition(
    canDbc: Optional[zio.aws.iotfleetwise.model.CanDbcDefinition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.NetworkFileDefinition = {
    import NetworkFileDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.NetworkFileDefinition
      .builder()
      .optionallyWith(canDbc.map(value => value.buildAwsValue()))(_.canDbc)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.NetworkFileDefinition.ReadOnly =
    zio.aws.iotfleetwise.model.NetworkFileDefinition.wrap(buildAwsValue())
}
object NetworkFileDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.NetworkFileDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.NetworkFileDefinition =
      zio.aws.iotfleetwise.model
        .NetworkFileDefinition(canDbc.map(value => value.asEditable))
    def canDbc: Optional[zio.aws.iotfleetwise.model.CanDbcDefinition.ReadOnly]
    def getCanDbc: ZIO[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.CanDbcDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("canDbc", canDbc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.NetworkFileDefinition
  ) extends zio.aws.iotfleetwise.model.NetworkFileDefinition.ReadOnly {
    override val canDbc
        : Optional[zio.aws.iotfleetwise.model.CanDbcDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canDbc())
        .map(value => zio.aws.iotfleetwise.model.CanDbcDefinition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.NetworkFileDefinition
  ): zio.aws.iotfleetwise.model.NetworkFileDefinition.ReadOnly = new Wrapper(
    impl
  )
}
