package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.CampaignName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCampaignRequest(name: CampaignName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest = {
    import GetCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest
      .builder()
      .name(CampaignName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetCampaignRequest.ReadOnly =
    zio.aws.iotfleetwise.model.GetCampaignRequest.wrap(buildAwsValue())
}
object GetCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetCampaignRequest =
      zio.aws.iotfleetwise.model.GetCampaignRequest(name)
    def name: CampaignName
    def getName: ZIO[Any, Nothing, CampaignName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest
  ) extends zio.aws.iotfleetwise.model.GetCampaignRequest.ReadOnly {
    override val name: CampaignName =
      zio.aws.iotfleetwise.model.primitives.CampaignName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest
  ): zio.aws.iotfleetwise.model.GetCampaignRequest.ReadOnly = new Wrapper(impl)
}
