package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  Priority,
  Timestamp,
  Arn,
  CampaignName,
  Description,
  Uint32,
  NodePath
}
import scala.jdk.CollectionConverters._
final case class CreateCampaignRequest(
    name: CampaignName,
    description: Optional[Description] = Optional.Absent,
    signalCatalogArn: Arn,
    targetArn: Arn,
    startTime: Optional[Timestamp] = Optional.Absent,
    expiryTime: Optional[Timestamp] = Optional.Absent,
    postTriggerCollectionDuration: Optional[Uint32] = Optional.Absent,
    diagnosticsMode: Optional[zio.aws.iotfleetwise.model.DiagnosticsMode] =
      Optional.Absent,
    spoolingMode: Optional[zio.aws.iotfleetwise.model.SpoolingMode] =
      Optional.Absent,
    compression: Optional[zio.aws.iotfleetwise.model.Compression] =
      Optional.Absent,
    priority: Optional[Priority] = Optional.Absent,
    signalsToCollect: Optional[
      Iterable[zio.aws.iotfleetwise.model.SignalInformation]
    ] = Optional.Absent,
    collectionScheme: zio.aws.iotfleetwise.model.CollectionScheme,
    dataExtraDimensions: Optional[Iterable[NodePath]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotfleetwise.model.Tag]] = Optional.Absent,
    dataDestinationConfigs: Optional[
      Iterable[zio.aws.iotfleetwise.model.DataDestinationConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest = {
    import CreateCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest
      .builder()
      .name(CampaignName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .signalCatalogArn(Arn.unwrap(signalCatalogArn): java.lang.String)
      .targetArn(Arn.unwrap(targetArn): java.lang.String)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        expiryTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiryTime)
      .optionallyWith(
        postTriggerCollectionDuration.map(value =>
          Uint32.unwrap(value): java.lang.Long
        )
      )(_.postTriggerCollectionDuration)
      .optionallyWith(diagnosticsMode.map(value => value.unwrap))(
        _.diagnosticsMode
      )
      .optionallyWith(spoolingMode.map(value => value.unwrap))(_.spoolingMode)
      .optionallyWith(compression.map(value => value.unwrap))(_.compression)
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(
        signalsToCollect.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.signalsToCollect)
      .collectionScheme(collectionScheme.buildAwsValue())
      .optionallyWith(
        dataExtraDimensions.map(value =>
          value.map { item =>
            NodePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataExtraDimensions)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dataDestinationConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataDestinationConfigs)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CreateCampaignRequest.ReadOnly =
    zio.aws.iotfleetwise.model.CreateCampaignRequest.wrap(buildAwsValue())
}
object CreateCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateCampaignRequest =
      zio.aws.iotfleetwise.model.CreateCampaignRequest(
        name,
        description.map(value => value),
        signalCatalogArn,
        targetArn,
        startTime.map(value => value),
        expiryTime.map(value => value),
        postTriggerCollectionDuration.map(value => value),
        diagnosticsMode.map(value => value),
        spoolingMode.map(value => value),
        compression.map(value => value),
        priority.map(value => value),
        signalsToCollect.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        collectionScheme.asEditable,
        dataExtraDimensions.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataDestinationConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: CampaignName
    def description: Optional[Description]
    def signalCatalogArn: Arn
    def targetArn: Arn
    def startTime: Optional[Timestamp]
    def expiryTime: Optional[Timestamp]
    def postTriggerCollectionDuration: Optional[Uint32]
    def diagnosticsMode: Optional[zio.aws.iotfleetwise.model.DiagnosticsMode]
    def spoolingMode: Optional[zio.aws.iotfleetwise.model.SpoolingMode]
    def compression: Optional[zio.aws.iotfleetwise.model.Compression]
    def priority: Optional[Priority]
    def signalsToCollect
        : Optional[List[zio.aws.iotfleetwise.model.SignalInformation.ReadOnly]]
    def collectionScheme: zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly
    def dataExtraDimensions: Optional[List[NodePath]]
    def tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]]
    def dataDestinationConfigs: Optional[
      List[zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, CampaignName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSignalCatalogArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(signalCatalogArn)
    def getTargetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(targetArn)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getExpiryTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiryTime", expiryTime)
    def getPostTriggerCollectionDuration: ZIO[Any, AwsError, Uint32] =
      AwsError.unwrapOptionField(
        "postTriggerCollectionDuration",
        postTriggerCollectionDuration
      )
    def getDiagnosticsMode
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.DiagnosticsMode] =
      AwsError.unwrapOptionField("diagnosticsMode", diagnosticsMode)
    def getSpoolingMode
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.SpoolingMode] =
      AwsError.unwrapOptionField("spoolingMode", spoolingMode)
    def getCompression
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.Compression] =
      AwsError.unwrapOptionField("compression", compression)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getSignalsToCollect: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.SignalInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("signalsToCollect", signalsToCollect)
    def getCollectionScheme: ZIO[
      Any,
      Nothing,
      zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly
    ] = ZIO.succeed(collectionScheme)
    def getDataExtraDimensions: ZIO[Any, AwsError, List[NodePath]] =
      AwsError.unwrapOptionField("dataExtraDimensions", dataExtraDimensions)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDataDestinationConfigs: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dataDestinationConfigs",
      dataDestinationConfigs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest
  ) extends zio.aws.iotfleetwise.model.CreateCampaignRequest.ReadOnly {
    override val name: CampaignName =
      zio.aws.iotfleetwise.model.primitives.CampaignName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val signalCatalogArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.signalCatalogArn())
    override val targetArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.targetArn())
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val expiryTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiryTime())
      .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val postTriggerCollectionDuration: Optional[Uint32] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postTriggerCollectionDuration())
        .map(value => zio.aws.iotfleetwise.model.primitives.Uint32(value))
    override val diagnosticsMode
        : Optional[zio.aws.iotfleetwise.model.DiagnosticsMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diagnosticsMode())
        .map(value => zio.aws.iotfleetwise.model.DiagnosticsMode.wrap(value))
    override val spoolingMode
        : Optional[zio.aws.iotfleetwise.model.SpoolingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spoolingMode())
        .map(value => zio.aws.iotfleetwise.model.SpoolingMode.wrap(value))
    override val compression: Optional[zio.aws.iotfleetwise.model.Compression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compression())
        .map(value => zio.aws.iotfleetwise.model.Compression.wrap(value))
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.iotfleetwise.model.primitives.Priority(value))
    override val signalsToCollect: Optional[
      List[zio.aws.iotfleetwise.model.SignalInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.signalsToCollect())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.SignalInformation.wrap(item)
        }.toList
      )
    override val collectionScheme
        : zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly =
      zio.aws.iotfleetwise.model.CollectionScheme.wrap(impl.collectionScheme())
    override val dataExtraDimensions: Optional[List[NodePath]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataExtraDimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.primitives.NodePath(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Tag.wrap(item)
          }.toList
        )
    override val dataDestinationConfigs: Optional[
      List[zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataDestinationConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.DataDestinationConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest
  ): zio.aws.iotfleetwise.model.CreateCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
