package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait VehicleAssociationBehavior {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior
}
object VehicleAssociationBehavior {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior
  ): zio.aws.iotfleetwise.model.VehicleAssociationBehavior = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior.CREATE_IOT_THING =>
      val r = CreateIotThing
      r
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior.VALIDATE_IOT_THING_EXISTS =>
      val r = ValidateIotThingExists
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.VehicleAssociationBehavior {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object CreateIotThing
      extends zio.aws.iotfleetwise.model.VehicleAssociationBehavior {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior.CREATE_IOT_THING
  }
  case object ValidateIotThingExists
      extends zio.aws.iotfleetwise.model.VehicleAssociationBehavior {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior.VALIDATE_IOT_THING_EXISTS
  }
}
