package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCampaignsResponse(
    campaignSummaries: Optional[
      Iterable[zio.aws.iotfleetwise.model.CampaignSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse = {
    import ListCampaignsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse
      .builder()
      .optionallyWith(
        campaignSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.campaignSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.ListCampaignsResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListCampaignsResponse.wrap(buildAwsValue())
}
object ListCampaignsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListCampaignsResponse =
      zio.aws.iotfleetwise.model.ListCampaignsResponse(
        campaignSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def campaignSummaries
        : Optional[List[zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getCampaignSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("campaignSummaries", campaignSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse
  ) extends zio.aws.iotfleetwise.model.ListCampaignsResponse.ReadOnly {
    override val campaignSummaries
        : Optional[List[zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.campaignSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.CampaignSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse
  ): zio.aws.iotfleetwise.model.ListCampaignsResponse.ReadOnly = new Wrapper(
    impl
  )
}
